/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import org.omnifaces.el.ELContextWrapper;
import org.omnifaces.el.ELResolverWrapper;
import org.omnifaces.el.MethodReference;
import org.omnifaces.el.functions.Strings;
import org.omnifaces.util.Reflection;

public final class ExpressionInspector {
    private ExpressionInspector() {
    }

    public static ValueReference getValueReference(ELContext context, ValueExpression valueExpression) {
        InspectorElContext inspectorElContext = new InspectorElContext(context);
        valueExpression.getType((ELContext)inspectorElContext);
        inspectorElContext.setPass(InspectorPass.PASS2_FIND_FINAL_NODE);
        valueExpression.getValue((ELContext)inspectorElContext);
        return new ValueReference(inspectorElContext.getBase(), inspectorElContext.getProperty());
    }

    public static MethodReference getMethodReference(ELContext context, ValueExpression valueExpression) {
        InspectorElContext inspectorElContext = new InspectorElContext(context);
        valueExpression.getType((ELContext)inspectorElContext);
        inspectorElContext.setPass(InspectorPass.PASS2_FIND_FINAL_NODE);
        ValueExpressionType type = (ValueExpressionType)((Object)valueExpression.getValue((ELContext)inspectorElContext));
        String methodName = inspectorElContext.getProperty().toString();
        Object[] params = inspectorElContext.getParams();
        if (type == ValueExpressionType.PROPERTY) {
            methodName = "get" + Strings.capitalize(methodName);
            params = MethodReference.NO_PARAMS;
        }
        return new MethodReference(inspectorElContext.getBase(), Reflection.findMethod(inspectorElContext.getBase(), methodName, params), inspectorElContext.getParams(), type == ValueExpressionType.METHOD);
    }

    static class InspectorElResolver
    extends ELResolverWrapper {
        private int passOneCallCount;
        private int passTwoCallCount;
        private Object lastBase;
        private Object lastProperty;
        private Object[] lastParams;
        private boolean subchainResolving;
        private FinalBaseHolder finalBaseHolder;
        private InspectorPass pass = InspectorPass.PASS1_FIND_NEXT_TO_LAST_NODE;

        public InspectorElResolver(ELResolver elResolver) {
            super(elResolver);
        }

        @Override
        public Object getValue(ELContext context, Object base, Object property) {
            if (base instanceof FinalBaseHolder) {
                this.lastBase = ((FinalBaseHolder)base).getBase();
                this.lastProperty = property;
                context.setPropertyResolved(true);
                return ValueExpressionType.PROPERTY;
            }
            this.checkSubchainStarted(base);
            if (this.subchainResolving) {
                return super.getValue(context, base, property);
            }
            this.recordCall(base, property);
            return this.wrapOutcomeIfNeeded(super.getValue(context, base, property));
        }

        @Override
        public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
            if (base instanceof FinalBaseHolder) {
                this.lastBase = ((FinalBaseHolder)base).getBase();
                this.lastProperty = method;
                this.lastParams = params;
                context.setPropertyResolved(true);
                return ValueExpressionType.METHOD;
            }
            this.checkSubchainStarted(base);
            if (this.subchainResolving) {
                return super.invoke(context, base, method, paramTypes, params);
            }
            this.recordCall(base, method);
            return this.wrapOutcomeIfNeeded(super.invoke(context, base, method, paramTypes, params));
        }

        @Override
        public Class<?> getType(ELContext context, Object base, Object property) {
            context.setPropertyResolved(true);
            return InspectorElContext.class;
        }

        private boolean isAtNextToLastNode() {
            return this.passTwoCallCount == this.passOneCallCount;
        }

        private void checkSubchainStarted(Object base) {
            if (this.pass == InspectorPass.PASS2_FIND_FINAL_NODE && base == null && this.isAtNextToLastNode()) {
                this.subchainResolving = true;
            }
        }

        private void recordCall(Object base, Object property) {
            switch (this.pass) {
                case PASS1_FIND_NEXT_TO_LAST_NODE: {
                    ++this.passOneCallCount;
                    this.lastBase = base;
                    this.lastProperty = property;
                    break;
                }
                case PASS2_FIND_FINAL_NODE: {
                    ++this.passTwoCallCount;
                    if (this.passTwoCallCount != this.passOneCallCount || base == this.lastBase && property == this.lastProperty) break;
                    throw new IllegalStateException("First and second pass of resolver at call #" + this.passTwoCallCount + " resolved to different base or property.");
                }
            }
        }

        private Object wrapOutcomeIfNeeded(Object outcome) {
            if (this.pass == InspectorPass.PASS2_FIND_FINAL_NODE && this.finalBaseHolder == null && this.isAtNextToLastNode()) {
                this.finalBaseHolder = new FinalBaseHolder(outcome);
                return this.finalBaseHolder;
            }
            return outcome;
        }

        public InspectorPass getPass() {
            return this.pass;
        }

        public void setPass(InspectorPass pass) {
            this.pass = pass;
        }

        public Object getBase() {
            return this.lastBase;
        }

        public Object getProperty() {
            return this.lastProperty;
        }

        public Object[] getParams() {
            return this.lastParams;
        }
    }

    static class FinalBaseHolder {
        private Object base;

        public FinalBaseHolder(Object base) {
            this.base = base;
        }

        public Object getBase() {
            return this.base;
        }
    }

    static class InspectorElContext
    extends ELContextWrapper {
        private final InspectorElResolver inspectorElResolver;

        public InspectorElContext(ELContext elContext) {
            super(elContext);
            this.inspectorElResolver = new InspectorElResolver(elContext.getELResolver());
        }

        @Override
        public ELResolver getELResolver() {
            return this.inspectorElResolver;
        }

        public InspectorPass getPass() {
            return this.inspectorElResolver.getPass();
        }

        public void setPass(InspectorPass pass) {
            this.inspectorElResolver.setPass(pass);
        }

        public Object getBase() {
            return this.inspectorElResolver.getBase();
        }

        public Object getProperty() {
            return this.inspectorElResolver.getProperty();
        }

        public Object[] getParams() {
            return this.inspectorElResolver.getParams();
        }
    }

    private static enum InspectorPass {
        PASS1_FIND_NEXT_TO_LAST_NODE,
        PASS2_FIND_FINAL_NODE;

    }

    private static enum ValueExpressionType {
        METHOD,
        PROPERTY;

    }
}

