/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.converter;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Utils;
import org.omnifaces.util.selectitems.SelectItemsUtils;

@FacesConverter(value="omnifaces.SelectItemsIndexConverter")
public class SelectItemsIndexConverter
implements Converter {
    private static final String ATTRIBUTE_SELECT_ITEMS = "SelectItemsIndexConverter.%s";
    private static final String ERROR_SELECT_ITEMS_LIST_INDEX = "Could not determine index for value ''{0}'' in component {1}.";
    private static final String ERROR_GET_AS_OBJECT = "Could not convert value ''{0}'' for component {1}.";

    public Object getAsObject(FacesContext context, UIComponent component, String submittedValue) {
        List<Object> selectItemValues = SelectItemsUtils.collectAllValuesFromSelectItems(context, component);
        try {
            return selectItemValues.get(Integer.parseInt(submittedValue));
        }
        catch (NumberFormatException e) {
            throw new ConverterException(Messages.createError(ERROR_SELECT_ITEMS_LIST_INDEX, submittedValue, component.getClientId(context)), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConverterException(Messages.createError(ERROR_GET_AS_OBJECT, submittedValue, component.getClientId(context)), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object modelValue) {
        String key = String.format(ATTRIBUTE_SELECT_ITEMS, component.getClientId(context));
        List<Object> selectItemValues = (List<Object>)Faces.getContextAttribute(key);
        if (selectItemValues == null) {
            selectItemValues = SelectItemsUtils.collectAllValuesFromSelectItems(context, component);
            Faces.setContextAttribute(key, selectItemValues);
        }
        for (int i = 0; i < selectItemValues.size(); ++i) {
            Object selectItemValue = selectItemValues.get(i);
            if (!(Utils.isEmpty(modelValue) ? Utils.isEmpty(selectItemValue) : modelValue.equals(selectItemValue))) continue;
            return Integer.toString(i);
        }
        return "";
    }
}

