/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Messages;

@FacesConverter(value="omnifaces.GenericEnumConverter")
public class GenericEnumConverter
implements Converter {
    private static final String ATTRIBUTE_ENUM_TYPE = "GenericEnumConverter.%s";
    private static final String ERROR_NO_ENUM_TYPE = "Given type ''{0}'' is not an enum.";
    private static final String ERROR_NO_ENUM_VALUE = "Given value ''{0}'' is not an enum of type ''{1}''.";

    public String getAsString(FacesContext context, UIComponent component, Object modelValue) {
        if (modelValue == null) {
            return "-";
        }
        if (modelValue instanceof Enum) {
            Class enumType = ((Enum)modelValue).getDeclaringClass();
            Faces.setViewAttribute(String.format(ATTRIBUTE_ENUM_TYPE, component.getClientId(context)), enumType);
            return ((Enum)modelValue).name();
        }
        throw new ConverterException(Messages.createError(ERROR_NO_ENUM_TYPE, modelValue.getClass()));
    }

    public Object getAsObject(FacesContext context, UIComponent component, String submittedValue) {
        if (submittedValue == null || submittedValue.isEmpty() || submittedValue.equals("-")) {
            return null;
        }
        Class enumType = (Class)Faces.getViewAttribute(String.format(ATTRIBUTE_ENUM_TYPE, component.getClientId(context)));
        try {
            return Enum.valueOf(enumType, submittedValue);
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException(Messages.createError(ERROR_NO_ENUM_VALUE, submittedValue, enumType), (Throwable)e);
        }
    }
}

