/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.context.ResponseWriter;
import org.omnifaces.config.WebXml;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Json;

public class OmniPartialViewContext
extends PartialViewContextWrapper {
    private static final String AJAX_DATA = "var OmniFaces=OmniFaces||{};OmniFaces.Ajax={data:%s};";
    private static final String ERROR_NO_OMNI_PVC = "There is no current OmniPartialViewContext instance.";
    private PartialViewContext wrapped;
    private Map<String, Object> arguments;
    private List<String> callbackScripts;
    private OmniPartialResponseWriter writer;

    public OmniPartialViewContext(PartialViewContext wrapped) {
        this.wrapped = wrapped;
        OmniPartialViewContext.setCurrentInstance(this);
    }

    public PartialResponseWriter getPartialResponseWriter() {
        if (this.writer == null) {
            this.writer = new OmniPartialResponseWriter(this, super.getPartialResponseWriter());
        }
        return this.writer;
    }

    public void setPartialRequest(boolean partialRequest) {
        this.getWrapped().setPartialRequest(partialRequest);
    }

    public PartialViewContext getWrapped() {
        return this.wrapped;
    }

    public void addArgument(String name, Object value) {
        if (this.arguments == null) {
            this.arguments = new HashMap<String, Object>();
        }
        this.arguments.put(name, value);
    }

    public void addCallbackScript(String callbackScript) {
        if (this.callbackScripts == null) {
            this.callbackScripts = new ArrayList<String>();
        }
        this.callbackScripts.add(callbackScript);
    }

    public void resetPartialResponse() {
        if (this.writer != null) {
            this.writer.reset();
        }
        this.arguments = null;
        this.callbackScripts = null;
    }

    public void closePartialResponse() {
        if (this.writer != null && this.writer.updating) {
            try {
                this.writer.endUpdate();
                this.writer.endDocument();
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    public static OmniPartialViewContext getCurrentInstance() {
        return OmniPartialViewContext.getCurrentInstance(Faces.getContext());
    }

    public static OmniPartialViewContext getCurrentInstance(FacesContext context) {
        PartialViewContext pvc;
        OmniPartialViewContext instance = (OmniPartialViewContext)((Object)FacesLocal.getContextAttribute(context, OmniPartialViewContext.class.getName()));
        if (instance != null) {
            return instance;
        }
        instance = OmniPartialViewContext.unwrap(context.getPartialViewContext());
        if (instance != null) {
            OmniPartialViewContext.setCurrentInstance(instance);
            return instance;
        }
        if (Hacks.isRichFacesInstalled() && (pvc = Hacks.getRichFacesWrappedPartialViewContext()) != null && (instance = OmniPartialViewContext.unwrap(pvc)) != null) {
            OmniPartialViewContext.setCurrentInstance(instance);
            return instance;
        }
        throw new IllegalStateException(ERROR_NO_OMNI_PVC);
    }

    private static void setCurrentInstance(OmniPartialViewContext instance) {
        Faces.setContextAttribute(OmniPartialViewContext.class.getName(), (Object)instance);
    }

    private static OmniPartialViewContext unwrap(PartialViewContext context) {
        PartialViewContext unwrappedContext = context;
        while (!(unwrappedContext instanceof OmniPartialViewContext) && unwrappedContext instanceof PartialViewContextWrapper) {
            unwrappedContext = ((PartialViewContextWrapper)unwrappedContext).getWrapped();
        }
        if (unwrappedContext instanceof OmniPartialViewContext) {
            return (OmniPartialViewContext)unwrappedContext;
        }
        return null;
    }

    private static class OmniPartialResponseWriter
    extends PartialResponseWriter {
        private OmniPartialViewContext context;
        private PartialResponseWriter wrapped;
        private boolean updating;

        public OmniPartialResponseWriter(OmniPartialViewContext context, PartialResponseWriter wrapped) {
            super((ResponseWriter)wrapped);
            this.wrapped = wrapped;
            this.context = context;
        }

        public void startDocument() throws IOException {
            String originalURL;
            FacesContext facesContext;
            String loginViewId;
            this.wrapped.startDocument();
            String loginURL = WebXml.INSTANCE.getFormLoginPage();
            if (loginURL != null && (loginViewId = FacesLocal.normalizeViewId(facesContext = FacesContext.getCurrentInstance(), loginURL)).equals(FacesLocal.getViewId(facesContext)) && (originalURL = (String)FacesLocal.getRequestAttribute(facesContext, "javax.servlet.forward.request_uri")) != null) {
                this.redirect(originalURL);
            }
        }

        public void startUpdate(String targetId) throws IOException {
            this.updating = true;
            this.wrapped.startUpdate(targetId);
        }

        public void endUpdate() throws IOException {
            this.updating = false;
            this.wrapped.endUpdate();
        }

        public void endDocument() throws IOException {
            if (this.updating) {
                this.endCDATA();
                this.endUpdate();
            } else {
                if (this.context.arguments != null) {
                    this.startEval();
                    this.write(String.format(OmniPartialViewContext.AJAX_DATA, Json.encode(this.context.arguments)));
                    this.endEval();
                }
                if (this.context.callbackScripts != null) {
                    for (String callbackScript : this.context.callbackScripts) {
                        this.startEval();
                        this.write(callbackScript);
                        this.endEval();
                    }
                }
            }
            this.wrapped.endDocument();
        }

        public void reset() {
            try {
                if (this.updating) {
                    this.endCDATA();
                    this.endUpdate();
                    this.wrapped.endDocument();
                }
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                Faces.responseReset();
            }
        }

        public void startError(String errorName) throws IOException {
            this.wrapped.startError(errorName);
        }

        public void startEval() throws IOException {
            this.wrapped.startEval();
        }

        public void startExtension(Map<String, String> attributes) throws IOException {
            this.wrapped.startExtension(attributes);
        }

        public void startInsertAfter(String targetId) throws IOException {
            this.wrapped.startInsertAfter(targetId);
        }

        public void startInsertBefore(String targetId) throws IOException {
            this.wrapped.startInsertBefore(targetId);
        }

        public void endError() throws IOException {
            this.wrapped.endError();
        }

        public void endEval() throws IOException {
            this.wrapped.endEval();
        }

        public void endExtension() throws IOException {
            this.wrapped.endExtension();
        }

        public void endInsert() throws IOException {
            this.wrapped.endInsert();
        }

        public void delete(String targetId) throws IOException {
            this.wrapped.delete(targetId);
        }

        public void redirect(String url) throws IOException {
            this.wrapped.redirect(url);
        }

        public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
            this.wrapped.updateAttributes(targetId, attributes);
        }
    }
}

