/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public enum FacesConfigXml {
    INSTANCE;

    private static final Logger logger;
    private static final String APP_FACES_CONFIG_XML = "/WEB-INF/faces-config.xml";
    private static final String LIB_FACES_CONFIG_XML = "META-INF/faces-config.xml";
    private static final String XPATH_RESOURCE_BUNDLE = "application/resource-bundle";
    private static final String XPATH_VAR = "var";
    private static final String XPATH_BASE_NAME = "base-name";
    private static final String ERROR_NOT_INITIALIZED = "FacesConfigXml is not initialized yet. Please use #init(ServletContext) method to manually initialize it.";
    private static final String LOG_INITIALIZATION_ERROR = "FacesConfigXml failed to initialize. Perhaps your faces-config.xml contains a typo?";
    private final AtomicBoolean initialized = new AtomicBoolean();
    private Map<String, String> resourceBundles;

    private void init() {
        if (!this.initialized.get() && Faces.hasContext()) {
            this.init(Faces.getServletContext());
        }
    }

    public FacesConfigXml init(ServletContext servletContext) {
        if (servletContext != null && !this.initialized.getAndSet(true)) {
            try {
                Element facesConfigXml = FacesConfigXml.loadFacesConfigXml(servletContext).getDocumentElement();
                XPath xpath = XPathFactory.newInstance().newXPath();
                this.resourceBundles = FacesConfigXml.parseResourceBundles(facesConfigXml, xpath);
            }
            catch (Exception e) {
                this.initialized.set(false);
                logger.log(Level.SEVERE, LOG_INITIALIZATION_ERROR, e);
                throw new UnsupportedOperationException(e);
            }
        }
        return this;
    }

    public Map<String, String> getResourceBundles() {
        this.checkInitialized();
        return this.resourceBundles;
    }

    private void checkInitialized() {
        this.init();
        if (!this.initialized.get()) {
            throw new IllegalStateException(ERROR_NOT_INITIALIZED);
        }
    }

    private static Document loadFacesConfigXml(ServletContext context) throws IOException, SAXException {
        ArrayList<URL> facesConfigURLs = new ArrayList<URL>();
        facesConfigURLs.add(context.getResource(APP_FACES_CONFIG_XML));
        facesConfigURLs.addAll(Collections.list(Thread.currentThread().getContextClassLoader().getResources(LIB_FACES_CONFIG_XML)));
        return Xml.createDocument(facesConfigURLs);
    }

    private static Map<String, String> parseResourceBundles(Element facesConfigXml, XPath xpath) throws XPathExpressionException {
        LinkedHashMap<String, String> resourceBundles = new LinkedHashMap<String, String>();
        NodeList resourceBundleNodes = Xml.getNodeList(facesConfigXml, xpath, XPATH_RESOURCE_BUNDLE);
        for (int i = 0; i < resourceBundleNodes.getLength(); ++i) {
            Node node = resourceBundleNodes.item(i);
            String var = xpath.compile(XPATH_VAR).evaluate(node).trim();
            String baseName = xpath.compile(XPATH_BASE_NAME).evaluate(node).trim();
            if (resourceBundles.containsKey(var)) continue;
            resourceBundles.put(var, baseName);
        }
        return Collections.unmodifiableMap(resourceBundles);
    }

    static {
        logger = Logger.getLogger(FacesConfigXml.class.getName());
    }
}

