/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import org.omnifaces.util.JNDI;

public enum BeanManager {
    INSTANCE;

    private static final Annotation[] NO_ANNOTATIONS;
    private static final String ERROR_CDI_API_UNAVAILABLE = "CDI API is not available in this environment.";
    private static final String ERROR_JNDI_UNAVAILABLE = "JNDI is not available in this environment.";
    private static final String ERROR_CDI_IMPL_UNAVAILABLE = "CDI BeanManager instance is not available in JNDI.";
    private static final String ERROR_INITIALIZATION_FAIL = "CDI BeanManager instance is available, but preparing getReference() method failed.";
    private Object beanManager;
    private Method getBeans;
    private Method resolve;
    private Method createCreationalContext;
    private Method getReference;

    private BeanManager() {
        Class<?> creationalContextClass;
        Class<?> beanClass;
        Class<?> contextualClass;
        Class<?> beanManagerClass;
        try {
            beanManagerClass = Class.forName("javax.enterprise.inject.spi.BeanManager");
            contextualClass = Class.forName("javax.enterprise.context.spi.Contextual");
            beanClass = Class.forName("javax.enterprise.inject.spi.Bean");
            creationalContextClass = Class.forName("javax.enterprise.context.spi.CreationalContext");
        }
        catch (Exception | LinkageError e) {
            throw new IllegalStateException(ERROR_CDI_API_UNAVAILABLE, e);
        }
        try {
            this.beanManager = JNDI.lookup("java:comp/BeanManager");
            if (this.beanManager == null) {
                this.beanManager = JNDI.lookup("java:comp/env/BeanManager");
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(ERROR_CDI_IMPL_UNAVAILABLE, e);
        }
        catch (Exception | LinkageError e) {
            throw new IllegalStateException(ERROR_JNDI_UNAVAILABLE, e);
        }
        if (this.beanManager == null) {
            throw new IllegalStateException(ERROR_CDI_IMPL_UNAVAILABLE);
        }
        try {
            this.getBeans = beanManagerClass.getMethod("getBeans", Type.class, Annotation[].class);
            this.resolve = beanManagerClass.getMethod("resolve", Set.class);
            this.createCreationalContext = beanManagerClass.getMethod("createCreationalContext", contextualClass);
            this.getReference = beanManagerClass.getMethod("getReference", beanClass, Type.class, creationalContextClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(ERROR_INITIALIZATION_FAIL, e);
        }
    }

    public <T> T get() {
        return (T)this.beanManager;
    }

    public <T> T getReference(Class<T> beanClass) {
        try {
            Object bean = this.resolve.invoke(this.beanManager, this.getBeans.invoke(this.beanManager, beanClass, NO_ANNOTATIONS));
            if (bean == null) {
                return null;
            }
            Object creationalContext = this.createCreationalContext.invoke(this.beanManager, bean);
            Object reference = this.getReference.invoke(this.beanManager, bean, beanClass, creationalContext);
            return beanClass.cast(reference);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        NO_ANNOTATIONS = new Annotation[0];
    }
}

