/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import org.omnifaces.component.validator.ValidatorFamily;
import org.omnifaces.el.ScopedRunner;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Messages;
import org.omnifaces.util.State;
import org.omnifaces.validator.MultiFieldValidator;

public abstract class ValidateMultipleFields
extends ValidatorFamily
implements MultiFieldValidator {
    private static final String DEFAULT_MESSAGE_BUNDLE = "org.omnifaces.component.validator.messages";
    private static final String DEFAULT_SHOWMESSAGEFOR = "@this";
    private static final Boolean DEFAULT_INVALIDATEALL = Boolean.TRUE;
    private static final Boolean DEFAULT_DISABLED = Boolean.FALSE;
    private static final String ERROR_MISSING_COMPONENTS = "%s attribute 'components' must be specified.";
    private static final String ERROR_UNKNOWN_COMPONENT = "%s attribute '%s' must refer existing client IDs. Client ID '%s' cannot be found.";
    private static final String ERROR_INVALID_COMPONENT = "%s attribute '%s' must refer UIInput client IDs. Client ID '%s' is of type '%s'.";
    private final State state = new State(this.getStateHelper());
    private String defaultMessage;
    private boolean validationFailed;

    public ValidateMultipleFields() {
        String componentType = this.getClass().getAnnotation(FacesComponent.class).value();
        ResourceBundle messageBundle = Faces.getMessageBundle();
        if (messageBundle == null || !messageBundle.containsKey(componentType)) {
            messageBundle = ResourceBundle.getBundle(DEFAULT_MESSAGE_BUNDLE, Faces.getLocale());
        }
        this.defaultMessage = messageBundle.getString(componentType);
        this.setRendererType(null);
    }

    @Override
    protected void validateHierarchy() throws IllegalArgumentException {
        Components.validateHasParent((UIComponent)this, UIForm.class);
        Components.validateHasNoChildren((UIComponent)this);
    }

    @Override
    protected void validateComponents(FacesContext context) {
        if (this.isDisabled()) {
            return;
        }
        List<UIInput> inputs = this.collectComponents();
        if (inputs.isEmpty()) {
            return;
        }
        List<Object> values = this.collectValues(inputs);
        if (!this.validateValues(context, inputs, values)) {
            int i = 0;
            for (UIInput input : inputs) {
                input.setValid(!this.isInvalidateAll() && !this.shouldInvalidateInput(context, input, values.get(i)));
                ++i;
            }
            this.validationFailed = true;
            context.validationFailed();
            this.showMessage(context, inputs);
        }
    }

    protected List<UIInput> collectComponents() {
        String components = this.getComponents();
        if (components.isEmpty()) {
            throw new IllegalArgumentException(String.format(ERROR_MISSING_COMPONENTS, this.getClass().getSimpleName()));
        }
        UIComponent namingContainerParent = this.getNamingContainer();
        ArrayList<UIInput> inputs = new ArrayList<UIInput>();
        for (String clientId : components.split("\\s+")) {
            UIInput input = this.findInputComponent(namingContainerParent, clientId, PropertyKeys.components);
            if (!Components.isEditable(input)) continue;
            if (!input.isValid()) {
                return Collections.emptyList();
            }
            inputs.add(input);
        }
        return Collections.unmodifiableList(inputs);
    }

    protected List<Object> collectValues(List<UIInput> inputs) {
        ArrayList values = new ArrayList(inputs.size());
        for (UIInput input : inputs) {
            Object value = Components.getValue((EditableValueHolder)input);
            if (input instanceof UISelectBoolean && Boolean.FALSE.equals(value)) {
                value = null;
            }
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    protected boolean shouldInvalidateInput(FacesContext context, UIInput input, Object value) {
        return true;
    }

    protected void showMessage(FacesContext context, List<UIInput> inputs) {
        final StringBuilder labels = new StringBuilder();
        Iterator<UIInput> iterator = inputs.iterator();
        while (iterator.hasNext()) {
            final UIInput input = iterator.next();
            new ScopedRunner(context).with("cc", UIComponent.getCompositeComponentParent((UIComponent)input)).invoke(new Callback.Void(){

                @Override
                public void invoke() {
                    labels.append(Components.getLabel((UIComponent)input));
                }
            });
            if (!iterator.hasNext()) continue;
            labels.append(", ");
        }
        String message = this.getMessage();
        String showMessageFor = this.getShowMessageFor();
        if (showMessageFor.equals(DEFAULT_SHOWMESSAGEFOR)) {
            Messages.addError(this.getClientId(context), message, labels);
        } else if (showMessageFor.equals("@all")) {
            for (UIInput input : inputs) {
                Messages.addError(input.getClientId(context), message, labels);
            }
        } else if (showMessageFor.equals("@invalid")) {
            for (UIInput input : inputs) {
                if (input.isValid()) continue;
                Messages.addError(input.getClientId(context), message, labels);
            }
        } else {
            UIComponent namingContainerParent = this.getNamingContainer();
            for (String clientId : showMessageFor.split("\\s+")) {
                UIInput input = this.findInputComponent(namingContainerParent, clientId, PropertyKeys.showMessageFor);
                Messages.addError(input.getClientId(context), message, labels);
            }
        }
    }

    private UIInput findInputComponent(UIComponent parent, String clientId, PropertyKeys property) {
        UIComponent found = parent.findComponent(clientId);
        if (found == null) {
            throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_COMPONENT, new Object[]{this.getClass().getSimpleName(), property, clientId}));
        }
        if (!(found instanceof UIInput)) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_COMPONENT, new Object[]{this.getClass().getSimpleName(), property, clientId, found.getClass().getName()}));
        }
        return (UIInput)found;
    }

    public String getComponents() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.components), "");
    }

    public void setComponents(String components) {
        this.state.put((Serializable)((Object)PropertyKeys.components), components);
    }

    public boolean isInvalidateAll() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.invalidateAll), DEFAULT_INVALIDATEALL);
    }

    public void setInvalidateAll(boolean invalidateAll) {
        this.state.put((Serializable)((Object)PropertyKeys.invalidateAll), invalidateAll);
    }

    public String getMessage() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.message), this.defaultMessage);
    }

    public void setMessage(String message) {
        this.state.put((Serializable)((Object)PropertyKeys.message), message);
    }

    public String getShowMessageFor() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.showMessageFor), DEFAULT_SHOWMESSAGEFOR);
    }

    public void setShowMessageFor(String showMessageFor) {
        this.state.put((Serializable)((Object)PropertyKeys.showMessageFor), showMessageFor);
    }

    public boolean isDisabled() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.disabled), DEFAULT_DISABLED);
    }

    public void setDisabled(boolean disabled) {
        this.state.put((Serializable)((Object)PropertyKeys.disabled), disabled);
    }

    public boolean isValidationFailed() {
        return this.validationFailed;
    }

    private static enum PropertyKeys {
        components,
        invalidateAll,
        message,
        showMessageFor,
        disabled;

    }
}

