/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.util;

import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.view.facelets.FaceletContext;
import org.omnifaces.component.util.FaceletContextConsumer;
import org.omnifaces.component.util.UtilFamily;
import org.omnifaces.el.ReadOnlyValueExpression;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.Events;
import org.omnifaces.util.Faces;
import org.omnifaces.util.State;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.util.ResolveComponent")
public class ResolveComponent
extends UtilFamily
implements FaceletContextConsumer,
SystemEventListener {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.util.ResolveComponent";
    private static final String ERROR_COMPONENT_NOT_FOUND = "A component with ID '%s' as specified by the 'for' attribute of the ResolveComponent with Id '%s' could not be found.";
    private static final String ERROR_ILLEGAL_SCOPE = "o:resolveComponent 'scope' attribute only supports 'facelet' (default) or 'request'. Encountered an invalid value of '%s'.";
    public static final String DEFAULT_SCOPE = "facelet";
    private ReadOnlyValueExpression readOnlyValueExpression;
    private final State state = new State(this.getStateHelper());

    @Override
    public void setFaceletContext(FaceletContext faceletContext) {
        if (this.getScope().equals(DEFAULT_SCOPE)) {
            this.readOnlyValueExpression = new ReadOnlyValueExpression(UIComponent.class);
            faceletContext.getVariableMapper().setVariable(this.getName(), (ValueExpression)this.readOnlyValueExpression);
        }
    }

    public ResolveComponent() {
        if (!Faces.isPostback()) {
            Events.subscribeToViewEvent(PreRenderViewEvent.class, this);
        }
    }

    public boolean isListenerForSource(Object source) {
        return true;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        this.doProcess();
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event instanceof PostRestoreStateEvent) {
            this.doProcess();
        }
    }

    public void doProcess() {
        String forValue = this.getFor();
        if (!Utils.isEmpty(forValue)) {
            String scope;
            Object component = Components.findComponentRelatively((UIComponent)this, forValue);
            if (component == null) {
                component = this.findComponent(forValue);
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format(ERROR_COMPONENT_NOT_FOUND, forValue, this.getId()));
            }
            switch (scope = this.getScope()) {
                case "facelet": {
                    if (this.readOnlyValueExpression == null) break;
                    this.readOnlyValueExpression.setCallbackReturning(new ComponentClientIdResolver(component.getClientId()));
                    break;
                }
                case "request": {
                    Faces.setRequestAttribute(this.getName(), component);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(ERROR_ILLEGAL_SCOPE, scope));
                }
            }
        }
    }

    public String getName() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.name));
    }

    public void setName(String nameValue) {
        this.state.put((Serializable)((Object)PropertyKeys.name), nameValue);
    }

    public String getFor() {
        return (String)this.state.get((Serializable)((Object)"for"));
    }

    public void setFor(String nameValue) {
        this.state.put((Serializable)((Object)"for"), nameValue);
    }

    public String getScope() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.scope), DEFAULT_SCOPE);
    }

    public void setScope(String scopeValue) {
        this.state.put((Serializable)((Object)PropertyKeys.scope), scopeValue);
    }

    public static class ComponentClientIdResolver
    implements Callback.SerializableReturning<Object> {
        private static final long serialVersionUID = 1L;
        private final String foundComponentId;
        private transient UIComponent foundComponent;

        public ComponentClientIdResolver(String foundComponentId) {
            this.foundComponentId = foundComponentId;
        }

        @Override
        public Object invoke() {
            if (this.foundComponent == null) {
                this.foundComponent = Components.findComponent(this.foundComponentId);
            }
            return this.foundComponent;
        }
    }

    static enum PropertyKeys {
        name,
        scope;

    }
}

