/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.component.util.UtilFamily;
import org.omnifaces.util.Components;
import org.omnifaces.util.Events;
import org.omnifaces.util.Faces;
import org.omnifaces.util.State;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.util.MoveComponent")
public class MoveComponent
extends UtilFamily
implements SystemEventListener,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.util.MoveComponent";
    private static final String ERROR_COMPONENT_NOT_FOUND = "A component with ID '%s' as specified by the 'for' attribute of the MoveComponent with Id '%s' could not be found.";
    public static final String DEFAULT_SCOPE = "facelet";
    private final State state = new State(this.getStateHelper());
    private String attachedEventName;
    private ClientBehavior attachedBehavior;
    private List<String> containsTrueList = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean contains(Object o) {
            return true;
        }
    };

    public MoveComponent() {
        if (!Faces.isPostback()) {
            Events.subscribeToViewEvent(PreRenderViewEvent.class, this);
        } else {
            Events.subscribeToViewEvent(PostAddToViewEvent.class, this);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PreRenderViewEvent || event instanceof PostAddToViewEvent && this.getDestination() == Destination.BEHAVIOR) {
            this.doProcess();
        }
    }

    public void addClientBehavior(String eventName, ClientBehavior behavior) {
        this.attachedEventName = eventName;
        this.attachedBehavior = behavior;
    }

    public String getDefaultEventName() {
        return this.getBehaviorDefaultEvent();
    }

    public Collection<String> getEventNames() {
        if (Utils.isEmpty(this.getBehaviorEvents())) {
            return this.containsTrueList;
        }
        return Utils.csvToList(this.getBehaviorEvents());
    }

    public void doProcess() {
        String forValue = this.getFor();
        if (!Utils.isEmpty(forValue)) {
            Object component = Components.findComponentRelatively((UIComponent)this, forValue);
            if (component == null) {
                component = this.findComponent(forValue);
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format(ERROR_COMPONENT_NOT_FOUND, forValue, this.getId()));
            }
            List<UIComponent> children = this.getChildrenInNewList();
            switch (this.getDestination()) {
                case BEFORE: {
                    this.moveBefore((UIComponent)component, children);
                    break;
                }
                case ADD_FIRST: {
                    this.moveAddFirst((UIComponent)component, children);
                    break;
                }
                case ADD_LAST: {
                    this.moveAddLast((UIComponent)component, children);
                    break;
                }
                case FACET: {
                    this.moveFacet((UIComponent)component, children);
                    break;
                }
                case BEHAVIOR: {
                    this.moveBehavior((UIComponent)component, this.attachedEventName, this.attachedBehavior);
                    break;
                }
                case AFTER: {
                    this.moveAfter((UIComponent)component, children);
                }
            }
        }
    }

    private void moveBefore(UIComponent component, List<UIComponent> children) {
        int targetIndex = component.getParent().getChildren().indexOf(component);
        for (int i = 0; i < children.size(); ++i) {
            UIComponent childComponent = children.get(i);
            component.getParent().getChildren().add(targetIndex + i, childComponent);
            childComponent.setId(childComponent.getId());
        }
    }

    private void moveAddFirst(UIComponent component, List<UIComponent> children) {
        for (int i = 0; i < children.size(); ++i) {
            UIComponent childComponent = children.get(i);
            component.getChildren().add(i, childComponent);
            childComponent.setId(childComponent.getId());
        }
    }

    private void moveAddLast(UIComponent component, List<UIComponent> children) {
        for (UIComponent childComponent : children) {
            component.getChildren().add(childComponent);
            childComponent.setId(childComponent.getId());
        }
    }

    private void moveFacet(UIComponent component, List<UIComponent> children) {
        for (UIComponent childComponent : children) {
            component.getFacets().put(this.getFacet(), childComponent);
            childComponent.setId(childComponent.getId());
        }
    }

    private void moveBehavior(UIComponent component, String event, ClientBehavior behavior) {
        ClientBehaviorHolder clientBehaviorHolder;
        List behaviors;
        if (component instanceof ClientBehaviorHolder && ((behaviors = (List)(clientBehaviorHolder = (ClientBehaviorHolder)component).getClientBehaviors().get(event)) == null || !behaviors.contains(behavior))) {
            clientBehaviorHolder.addClientBehavior(event, behavior);
        }
    }

    private void moveAfter(UIComponent component, List<UIComponent> children) {
        int targetComponentIndex = component.getParent().getChildren().indexOf(component);
        int targetIndex = targetComponentIndex + 1;
        for (int i = 0; i < children.size(); ++i) {
            UIComponent childComponent = children.get(i);
            component.getParent().getChildren().add(targetIndex + i, childComponent);
            childComponent.setId(childComponent.getId());
        }
    }

    private List<UIComponent> getChildrenInNewList() {
        return new ArrayList<UIComponent>(this.getChildren());
    }

    public String getFor() {
        return (String)this.state.get((Serializable)((Object)"for"));
    }

    public void setFor(String nameValue) {
        this.state.put((Serializable)((Object)"for"), nameValue);
    }

    public Destination getDestination() {
        return (Destination)((Object)this.state.get((Serializable)((Object)PropertyKeys.destination), (Object)Destination.ADD_LAST));
    }

    public void setDestination(Destination destinationValue) {
        this.state.put((Serializable)((Object)PropertyKeys.destination), destinationValue);
    }

    public String getFacet() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.facet));
    }

    public void setFacet(String facetValue) {
        this.state.put((Serializable)((Object)PropertyKeys.facet), facetValue);
    }

    public String getBehaviorDefaultEvent() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.behaviorDefaultEvent), "");
    }

    public void setBehaviorDefaultEvent(String behaviorDefaultEventValue) {
        this.state.put((Serializable)((Object)PropertyKeys.behaviorDefaultEvent), behaviorDefaultEventValue);
    }

    public String getBehaviorEvents() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.behaviorEvents));
    }

    public void setBehaviorEvents(String behaviorEventsValue) {
        this.state.put((Serializable)((Object)PropertyKeys.behaviorEvents), behaviorEventsValue);
    }

    public static enum Destination {
        BEFORE,
        ADD_FIRST,
        ADD_LAST,
        FACET,
        BEHAVIOR,
        AFTER;

    }

    static enum PropertyKeys {
        facet,
        destination,
        behaviorDefaultEvent,
        behaviorEvents;

    }
}

