/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.script;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.component.script.ScriptFamily;
import org.omnifaces.util.Ajax;
import org.omnifaces.util.Events;

@FacesComponent(value="org.omnifaces.component.script.OnloadScript")
@ListenersFor(value={@ListenerFor(systemEventClass=PostAddToViewEvent.class), @ListenerFor(systemEventClass=PostRestoreStateEvent.class)})
public class OnloadScript
extends ScriptFamily
implements SystemEventListener {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.script.OnloadScript";

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        OnloadScript.moveToBody(event, this);
        if (event instanceof PostRestoreStateEvent) {
            Events.subscribeToViewEvent(PreRenderViewEvent.class, this);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof OnloadScript || source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (!(event instanceof PreRenderViewEvent) || !this.isRendered()) {
            return;
        }
        FacesContext context = this.getFacesContext();
        if (!this.isAjaxRequestWithPartialRendering(context)) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        StringWriter buffer = new StringWriter();
        ResponseWriter originalResponseWriter = context.getResponseWriter();
        String encoding = context.getExternalContext().getRequestCharacterEncoding();
        context.getExternalContext().setResponseCharacterEncoding(encoding);
        final ResponseWriter writer = context.getRenderKit().createResponseWriter((Writer)buffer, null, encoding);
        context.setResponseWriter((ResponseWriter)new ResponseWriterWrapper(){

            public void writeText(Object text, String property) throws IOException {
                writer.write(text.toString());
            }

            public ResponseWriter getWrapped() {
                return writer;
            }
        });
        try {
            this.encodeChildren(context);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this.popComponentFromEL(context);
            if (originalResponseWriter != null) {
                context.setResponseWriter(originalResponseWriter);
            }
        }
        String script = buffer.toString().trim();
        if (!script.isEmpty()) {
            Ajax.oncomplete(script);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered() || this.isAjaxRequestWithPartialRendering(context)) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered() || this.isAjaxRequestWithPartialRendering(context)) {
            return;
        }
        context.getResponseWriter().endElement("script");
        this.popComponentFromEL(context);
    }

    private boolean isAjaxRequestWithPartialRendering(FacesContext context) {
        PartialViewContext pvc = context.getPartialViewContext();
        return pvc.isAjaxRequest() && !pvc.isRenderAll();
    }
}

