/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.script;

import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.faces.application.ResourceDependency;
import javax.faces.component.FacesComponent;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.omnifaces.component.ParamHolder;
import org.omnifaces.util.Components;
import org.omnifaces.util.Json;
import org.omnifaces.util.State;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.script.CommandScript")
@ResourceDependency(library="javax.faces", name="jsf.js", target="head")
public class CommandScript
extends UICommand {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.script.CommandScript";
    private static final Pattern PATTERN_NAME = Pattern.compile("[$a-z_][$\\w]*", 2);
    private static final String ERROR_MISSING_NAME = "o:commandScript 'name' attribute must be specified.";
    private static final String ERROR_ILLEGAL_NAME = "o:commandScript 'name' attribute '%s' does not represent a valid script function name.";
    private static final String ERROR_UNKNOWN_CLIENTID = "o:commandScript execute/render client ID '%s' cannot be found relative to parent NamingContainer component with client ID '%s'.";
    private final State state = new State(this.getStateHelper());

    public CommandScript() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.omnifaces.component.script";
    }

    public void decode(FacesContext context) {
        String source = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        if (this.getClientId(context).equals(source)) {
            ActionEvent event = new ActionEvent((UIComponent)this);
            event.setPhaseId(this.isImmediate() ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION);
            this.queueEvent((FacesEvent)event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        Components.validateHasParent((UIComponent)this, UIForm.class);
        String name = this.getName();
        if (name == null) {
            throw new IllegalArgumentException(ERROR_MISSING_NAME);
        }
        if (!PATTERN_NAME.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format(ERROR_ILLEGAL_NAME, name));
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)this);
        writer.writeAttribute("id", (Object)this.getClientId(context), "id");
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        this.encodeFunction(context, name);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("script");
        writer.endElement("span");
    }

    protected void encodeFunction(FacesContext context, String name) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.append((CharSequence)"var ").append(name).append('=').append("function(o){var o=(typeof o==='object')&&o?o:{};");
        this.encodeOptions(context);
        writer.append((CharSequence)"jsf.ajax.request('").append(this.getClientId(context)).append("',null,o)}");
    }

    protected void encodeOptions(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (ParamHolder param : Components.getParams((UIComponent)this)) {
            writer.append((CharSequence)"o[").append(Json.encode(param.getName())).append("]=").append(Json.encode(param.getValue())).append(";");
        }
        writer.append((CharSequence)"o['javax.faces.behavior.event']='action';");
        writer.append((CharSequence)"o.execute='").append(this.resolveClientIds(context, this.getExecute())).append("';");
        writer.append((CharSequence)"o.render='").append(this.resolveClientIds(context, this.getRender())).append("';");
        this.encodeOneventOption(context, this.getOnbegin(), this.getOncomplete());
    }

    protected void encodeOneventOption(FacesContext context, String onbegin, String oncomplete) throws IOException {
        if (onbegin == null && oncomplete == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.write("o.onevent=function(data){");
        if (onbegin != null) {
            writer.append((CharSequence)"if(data.status=='begin'){").append(onbegin).append('}');
        }
        if (oncomplete != null) {
            writer.append((CharSequence)"if(data.status=='success'){").append(oncomplete).append('}');
        }
        writer.write("};");
    }

    protected String resolveClientIds(FacesContext context, String relativeClientIds) {
        if (Utils.isEmpty(relativeClientIds)) {
            return null;
        }
        StringBuilder absoluteClientIds = new StringBuilder();
        for (String relativeClientId : relativeClientIds.split("\\s+")) {
            if (absoluteClientIds.length() > 0) {
                absoluteClientIds.append(' ');
            }
            if (relativeClientId.charAt(0) == '@') {
                absoluteClientIds.append(relativeClientId);
                continue;
            }
            UIComponent found = this.findComponent(relativeClientId);
            if (found == null) {
                throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_CLIENTID, relativeClientId, this.getNamingContainer().getClientId(context)));
            }
            absoluteClientIds.append(found.getClientId(context));
        }
        return absoluteClientIds.toString();
    }

    public String getName() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.name));
    }

    public void setName(String name) {
        this.state.put((Serializable)((Object)PropertyKeys.name), name);
    }

    public String getExecute() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.execute), "@this");
    }

    public void setExecute(String execute) {
        this.state.put((Serializable)((Object)PropertyKeys.execute), execute);
    }

    public String getRender() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.render), "@none");
    }

    public void setRender(String render) {
        this.state.put((Serializable)((Object)PropertyKeys.render), render);
    }

    public String getOnbegin() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.onbegin));
    }

    public void setOnbegin(String onbegin) {
        this.state.put((Serializable)((Object)PropertyKeys.onbegin), onbegin);
    }

    public String getOncomplete() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.oncomplete));
    }

    public void setOncomplete(String oncomplete) {
        this.state.put((Serializable)((Object)PropertyKeys.oncomplete), oncomplete);
    }

    private static enum PropertyKeys {
        name,
        execute,
        render,
        onbegin,
        oncomplete;

    }
}

