/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.omnifaces.component.output.cache.CacheFactory;
import org.omnifaces.component.output.cache.CacheProvider;
import org.omnifaces.filter.OnDemandResponseBufferFilter;
import org.omnifaces.util.Platform;

public final class CacheInitializer {
    public static final String CACHE_PROVIDER_INIT_PARAM_NAME = "org.omnifaces.CACHE_PROVIDER";
    public static final String CACHE_INSTALL_BUFFER_FILTER = "org.omnifaces.CACHE_INSTALL_BUFFER_FILTER";
    public static final String CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX = "org.omnifaces.CACHE_SETTING_";

    private CacheInitializer() {
    }

    public static void loadProviderAndRegisterFilter(ServletContext context) {
        CacheProvider cacheProvider = CacheInitializer.getCacheProvider(context);
        cacheProvider.setParameters(CacheInitializer.getCacheSetting(context));
        if (Boolean.TRUE.equals(Boolean.valueOf(context.getInitParameter(CACHE_INSTALL_BUFFER_FILTER)))) {
            ServletRegistration facesServletRegistration = Platform.getFacesServletRegistration(context);
            FilterRegistration.Dynamic bufferFilterRegistration = context.addFilter(OnDemandResponseBufferFilter.class.getName(), OnDemandResponseBufferFilter.class);
            bufferFilterRegistration.addMappingForServletNames(null, true, new String[]{facesServletRegistration.getName()});
        }
    }

    private static CacheProvider getCacheProvider(ServletContext context) {
        CacheProvider cacheProvider = null;
        String cacheProviderName = context.getInitParameter(CACHE_PROVIDER_INIT_PARAM_NAME);
        if (cacheProviderName != null) {
            cacheProvider = CacheInitializer.createInstance(cacheProviderName);
            CacheFactory.setCacheProvider(cacheProvider, context);
        } else {
            cacheProvider = CacheFactory.getDefaultCacheProvider();
        }
        return cacheProvider;
    }

    private static CacheProvider createInstance(String cacheProviderName) {
        try {
            return (CacheProvider)Class.forName(cacheProviderName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Map<String, String> getCacheSetting(ServletContext context) {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (String initParameterName : Collections.list(context.getInitParameterNames())) {
            if (!initParameterName.startsWith(CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX)) continue;
            settings.put(initParameterName.substring(CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX.length()), context.getInitParameter(initParameterName));
        }
        return settings;
    }
}

