/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.omnifaces.resourcehandler.GraphicResource;
import org.omnifaces.util.Renderers;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.output.GraphicImage")
public class GraphicImage
extends HtmlGraphicImage {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.output.GraphicImage";
    public static final Map<String, String> ATTRIBUTE_NAMES = GraphicImage.collectAttributeNames();
    private static final String ERROR_MISSING_VALUE = "o:graphicImage 'value' attribute is required.";

    private static Map<String, String> collectAttributeNames() {
        HashMap<String, String> attributeNames = new HashMap<String, String>();
        for (HtmlGraphicImage.PropertyKeys propertyKey : HtmlGraphicImage.PropertyKeys.values()) {
            String name;
            attributeNames.put(name, "styleClass".equals(name = propertyKey.name()) ? "class" : propertyKey.toString());
        }
        return Collections.unmodifiableMap(attributeNames);
    }

    public GraphicImage() {
        this.setRendererType(null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", (UIComponent)this);
        writer.writeAttribute("src", (Object)this.getSrc(context), "value");
        Renderers.writeAttributes(writer, (UIComponent)this, ATTRIBUTE_NAMES);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("img");
    }

    protected String getSrc(FacesContext context) throws IOException {
        Resource resource;
        String name = (String)this.getAttributes().get("name");
        boolean dataURI = Boolean.valueOf(String.valueOf(this.getAttributes().get("dataURI")));
        if (name != null) {
            String library = (String)this.getAttributes().get("library");
            resource = context.getApplication().getResourceHandler().createResource(name, library);
            if (resource == null) {
                return "RES_NOT_FOUND";
            }
            if (dataURI && resource.getContentType().startsWith("image")) {
                resource = new GraphicResource(resource.getInputStream(), resource.getContentType());
            }
        } else {
            ValueExpression value = this.getValueExpression("value");
            if (value == null) {
                throw new IllegalArgumentException(ERROR_MISSING_VALUE);
            }
            String type = (String)this.getAttributes().get("type");
            resource = dataURI ? new GraphicResource(value.getValue(context.getELContext()), type) : GraphicResource.create(context, value, type, this.getAttributes().get("lastModified"));
        }
        String fragment = (String)this.getAttributes().get("fragment");
        String fragmentString = dataURI || Utils.isEmpty(fragment) ? "" : (fragment.charAt(0) == '#' ? "" : "#") + fragment;
        return context.getExternalContext().encodeResourceURL(resource.getRequestPath()) + fragmentString;
    }

    public String getAlt() {
        return Utils.coalesce(super.getAlt(), "");
    }
}

