/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.param;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.validator.RequiredValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.omnifaces.cdi.Param;
import org.omnifaces.cdi.param.Attribute;
import org.omnifaces.cdi.param.ParamValue;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Platform;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Utils;

public class RequestParameterProducer {
    @Inject
    private InjectionPoint injectionPoint;

    @Produces
    @Param
    public <V> ParamValue<V> produce(InjectionPoint injectionPoint) {
        Param requestParameter = Beans.getQualifier(injectionPoint, Param.class);
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot component = context.getViewRoot();
        String label = this.getLabel(requestParameter, injectionPoint);
        component.getAttributes().put("label", label);
        String submittedValue = FacesLocal.getRequestParameter(context, this.getName(requestParameter, injectionPoint));
        Object convertedValue = null;
        boolean valid = true;
        try {
            Converter converter = RequestParameterProducer.getConverter(requestParameter, this.getTargetType(injectionPoint));
            convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)component, submittedValue) : submittedValue;
            if (requestParameter.required() && Utils.isEmpty(convertedValue)) {
                this.addRequiredMessage(context, (UIComponent)component, label, submittedValue, this.getRequiredMessage(requestParameter));
            }
            if (this.shouldDoBeanValidation(requestParameter)) {
                Set<ConstraintViolation<?>> violations = this.doBeanValidation(convertedValue, injectionPoint);
                valid = violations.isEmpty();
                for (ConstraintViolation<?> violation : violations) {
                    context.addMessage(component.getClientId(context), Messages.createError(violation.getMessage(), label));
                }
            }
            for (Validator validator : this.getValidators(requestParameter)) {
                try {
                    validator.validate(context, (UIComponent)component, convertedValue);
                }
                catch (ValidatorException ve) {
                    valid = false;
                    this.addValidatorMessages(context, (UIComponent)component, label, submittedValue, ve, this.getValidatorMessage(requestParameter));
                }
            }
        }
        catch (ConverterException ce) {
            valid = false;
            this.addConverterMessage(context, (UIComponent)component, label, submittedValue, ce, this.getConverterMessage(requestParameter));
        }
        if (!valid) {
            context.validationFailed();
            convertedValue = null;
        }
        return new ParamValue<Object>(submittedValue, requestParameter, this.getTargetType(injectionPoint), convertedValue);
    }

    public static Converter getConverter(Param requestParameter, Class<?> targetType) {
        Class<? extends Converter> converterClass = requestParameter.converterClass();
        String converterName = requestParameter.converter();
        Converter converter = null;
        if (!Utils.isEmpty(converterName)) {
            Object expressionResult = Faces.evaluateExpressionGet(converterName);
            if (expressionResult instanceof Converter) {
                converter = (Converter)expressionResult;
            } else if (expressionResult instanceof String) {
                converter = Faces.getApplication().createConverter((String)expressionResult);
            }
        } else if (!converterClass.equals(Converter.class)) {
            converter = Reflection.instance(converterClass);
        }
        if (converter == null) {
            try {
                converter = Faces.getApplication().createConverter(targetType);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (converter != null) {
            Reflection.setPropertiesWithCoercion(converter, RequestParameterProducer.getConverterAttributes(requestParameter));
        }
        return converter;
    }

    private <V> Class<V> getTargetType(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    private String getName(Param requestParameter, InjectionPoint injectionPoint) {
        String name = requestParameter.name();
        name = Utils.isEmpty(name) ? injectionPoint.getMember().getName() : this.evaluateExpressionAsString(name);
        return name;
    }

    private String getLabel(Param requestParameter, InjectionPoint injectionPoint) {
        String label = requestParameter.label();
        label = Utils.isEmpty(label) ? this.getName(requestParameter, injectionPoint) : this.evaluateExpressionAsString(label);
        return label;
    }

    private String getValidatorMessage(Param requestParameter) {
        return this.evaluateExpressionAsString(requestParameter.validatorMessage());
    }

    private String getConverterMessage(Param requestParameter) {
        return this.evaluateExpressionAsString(requestParameter.converterMessage());
    }

    private String getRequiredMessage(Param requestParameter) {
        return this.evaluateExpressionAsString(requestParameter.requiredMessage());
    }

    private String evaluateExpressionAsString(String expression) {
        if (Utils.isEmpty(expression)) {
            return expression;
        }
        Object expressionResult = Faces.evaluateExpressionGet(expression);
        if (expressionResult == null) {
            return null;
        }
        return expressionResult.toString();
    }

    private boolean shouldDoBeanValidation(Param requestParameter) {
        if (requestParameter.disableBeanValidation()) {
            return false;
        }
        if (!requestParameter.overrideGlobalBeanValidationDisabled() && Boolean.valueOf(Faces.getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR")).booleanValue()) {
            return false;
        }
        return Platform.isBeanValidationAvailable();
    }

    private Set<ConstraintViolation<?>> doBeanValidation(Object value, InjectionPoint injectionPoint) {
        Set violationsRaw;
        Type propertyRawType;
        Class base = injectionPoint.getBean().getBeanClass();
        String property = injectionPoint.getMember().getName();
        Type type = injectionPoint.getType();
        ParamValue<Object> valueOrWrapper = value;
        if (type instanceof ParameterizedType && (propertyRawType = ((ParameterizedType)type).getRawType()).equals(ParamValue.class)) {
            valueOrWrapper = new ParamValue<Object>(null, null, null, value);
        }
        Set violations = violationsRaw = Platform.getBeanValidator().validateValue(base, property, (Object)valueOrWrapper, new Class[0]);
        return violations;
    }

    private List<Validator> getValidators(Param requestParameter) {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        Class<? extends Validator>[] validatorClasses = requestParameter.validatorClasses();
        String[] validatorNames = requestParameter.validators();
        for (String validatorName : validatorNames) {
            Object validator = Faces.evaluateExpressionGet(validatorName);
            if (validator instanceof Validator) {
                validators.add((Validator)validator);
                continue;
            }
            if (!(validator instanceof String)) continue;
            validators.add(Faces.getApplication().createValidator(validatorName));
        }
        for (Class<? extends Validator> validatorClass : validatorClasses) {
            validators.add((Validator)Reflection.instance(validatorClass));
        }
        Application application = Faces.getApplication();
        for (Map.Entry validatorEntry : application.getDefaultValidatorInfo().entrySet()) {
            String validatorID = (String)validatorEntry.getKey();
            String validatorClassName = (String)validatorEntry.getValue();
            if (validatorID.equals("javax.faces.Bean") || Utils.containsByClassName(validators, validatorClassName)) continue;
            validators.add(application.createValidator(validatorID));
        }
        Map<String, Object> validatorAttributes = this.getValidatorAttributes(requestParameter);
        for (Validator validator : validators) {
            Reflection.setPropertiesWithCoercion(validator, validatorAttributes);
        }
        return validators;
    }

    private static Map<String, Object> getConverterAttributes(Param requestParameter) {
        Attribute[] attributes;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (Attribute attribute : attributes = requestParameter.converterAttributes()) {
            attributeMap.put(attribute.name(), Faces.evaluateExpressionGet(attribute.value()));
        }
        return attributeMap;
    }

    private Map<String, Object> getValidatorAttributes(Param requestParameter) {
        Attribute[] attributes;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (Attribute attribute : attributes = requestParameter.validatorAttributes()) {
            attributeMap.put(attribute.name(), Faces.evaluateExpressionGet(attribute.value()));
        }
        return attributeMap;
    }

    private void addConverterMessage(FacesContext context, UIComponent component, String label, String submittedValue, ConverterException ce, String converterMessage) {
        FacesMessage message = null;
        if (!Utils.isEmpty(converterMessage)) {
            message = Messages.createError(converterMessage, submittedValue, label);
        } else {
            message = ce.getFacesMessage();
            if (message == null) {
                message = Messages.createError("Conversion failed for {0} because: {1}", submittedValue, ce.getMessage());
            }
        }
        context.addMessage(component.getClientId(context), message);
    }

    private void addRequiredMessage(FacesContext context, UIComponent component, String label, String submittedValue, String requiredMessage) {
        FacesMessage message = null;
        if (!Utils.isEmpty(requiredMessage)) {
            message = Messages.createError(requiredMessage, submittedValue, label);
        } else {
            try {
                new RequiredValidator().validate(context, component, (Object)submittedValue);
            }
            catch (ValidatorException ve) {
                message = ve.getFacesMessage();
            }
            if (message == null) {
                message = Messages.createError("{0}: A value is required!", label);
            }
        }
        context.addMessage(component.getClientId(context), message);
    }

    private void addValidatorMessages(FacesContext context, UIComponent component, String label, String submittedValue, ValidatorException ve, String validatorMessage) {
        String clientId = component.getClientId(context);
        if (!Utils.isEmpty(validatorMessage)) {
            context.addMessage(clientId, Messages.createError(validatorMessage, submittedValue, label));
        } else {
            for (FacesMessage facesMessage : RequestParameterProducer.getFacesMessages(ve)) {
                context.addMessage(clientId, facesMessage);
            }
        }
    }

    private static List<FacesMessage> getFacesMessages(ValidatorException ve) {
        ArrayList<FacesMessage> facesMessages = new ArrayList<FacesMessage>();
        if (ve.getFacesMessages() != null) {
            facesMessages.addAll(ve.getFacesMessages());
        } else if (ve.getFacesMessage() != null) {
            facesMessages.add(ve.getFacesMessage());
        }
        return facesMessages;
    }
}

