/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.param;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.omnifaces.cdi.Param;
import org.omnifaces.cdi.param.RequestParameterProducer;

public class ParamValue<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String submittedValue;
    private final Param requestParameter;
    private final Class<?> targetType;
    private transient V value;
    private boolean valueSet;
    private V serializableValue;
    private boolean valueIsSerializable;

    public ParamValue(String submittedValue, Param requestParameter, Class<?> targetType, V value) {
        this.submittedValue = submittedValue;
        this.requestParameter = requestParameter;
        this.targetType = targetType;
        this.value = value;
        this.valueSet = true;
        if (value instanceof Serializable) {
            this.serializableValue = value;
            this.valueIsSerializable = true;
        }
    }

    public V getValue() {
        if (!this.valueSet) {
            if (this.valueIsSerializable) {
                this.value = this.serializableValue;
            } else {
                Object convertedValue;
                Converter converter = RequestParameterProducer.getConverter(this.requestParameter, this.targetType);
                if (converter != null) {
                    FacesContext context = FacesContext.getCurrentInstance();
                    convertedValue = converter.getAsObject(context, (UIComponent)context.getViewRoot(), this.submittedValue);
                } else {
                    convertedValue = this.submittedValue;
                }
                this.value = convertedValue;
            }
            this.valueSet = true;
        }
        return this.value;
    }

    public String getSubmittedValue() {
        return this.submittedValue;
    }
}

