/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.eager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import org.omnifaces.cdi.Eager;
import org.omnifaces.cdi.ViewScoped;
import org.omnifaces.cdi.eager.EagerBeansRepository;
import org.omnifaces.util.BeansLocal;
import org.omnifaces.util.Utils;

public class EagerExtension
implements Extension {
    private static final Logger logger = Logger.getLogger(EagerExtension.class.getName());
    private static final String MISSING_REQUEST_URI_OR_VIEW_ID = "Bean %s with scope %s was annotated with @Eager, but required attribute 'requestURI' or 'viewId' is missing. Bean will not be eagerly instantiated.";
    private static final String MISSING_VIEW_ID = "Bean %s with scope %s was annotated with @Eager, but required attribute 'viewId' is missing. Bean will not be eagerly instantiated.";
    private static final String ERROR_EAGER_UNAVAILABLE = "@Eager is unavailable. The EagerBeansRepository could not be obtained from CDI bean manager.";
    private List<Bean<?>> applicationScopedBeans = new ArrayList();
    private List<Bean<?>> sessionScopedBeans = new ArrayList();
    private Map<String, List<Bean<?>>> requestScopedBeansViewId = new HashMap();
    private Map<String, List<Bean<?>>> requestScopedBeansRequestURI = new HashMap();

    public <T> void collect(@Observes ProcessBean<T> event, BeanManager beanManager) {
        Annotated annotated = event.getAnnotated();
        Eager eager = BeansLocal.getAnnotation(beanManager, annotated, Eager.class);
        if (eager != null) {
            Bean bean = event.getBean();
            if (BeansLocal.getAnnotation(beanManager, annotated, ApplicationScoped.class) != null) {
                this.applicationScopedBeans.add(bean);
            } else if (BeansLocal.getAnnotation(beanManager, annotated, SessionScoped.class) != null) {
                this.sessionScopedBeans.add(bean);
            } else if (BeansLocal.getAnnotation(beanManager, annotated, RequestScoped.class) != null) {
                this.addRequestScopedBean(eager, bean);
            } else if (BeansLocal.getAnnotation(beanManager, annotated, javax.faces.view.ViewScoped.class) != null) {
                this.addViewScopedBean(eager, bean);
            } else if (BeansLocal.getAnnotation(beanManager, annotated, ViewScoped.class) != null) {
                this.addOmniViewScopedBean(eager, bean);
            }
        }
    }

    public void load(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        EagerBeansRepository eagerBeansRepository = BeansLocal.getReference(beanManager, EagerBeansRepository.class);
        if (eagerBeansRepository == null) {
            logger.warning(ERROR_EAGER_UNAVAILABLE);
            return;
        }
        if (!this.applicationScopedBeans.isEmpty()) {
            eagerBeansRepository.setApplicationScopedBeans(Collections.unmodifiableList(this.applicationScopedBeans));
        }
        if (!this.sessionScopedBeans.isEmpty()) {
            eagerBeansRepository.setSessionScopedBeans(Collections.unmodifiableList(this.sessionScopedBeans));
        }
        if (!this.requestScopedBeansRequestURI.isEmpty()) {
            eagerBeansRepository.setRequestScopedBeansRequestURI(Collections.unmodifiableMap(this.requestScopedBeansRequestURI));
        }
        if (!this.requestScopedBeansViewId.isEmpty()) {
            eagerBeansRepository.setRequestScopedBeansViewId(Collections.unmodifiableMap(this.requestScopedBeansViewId));
        }
    }

    private void addRequestScopedBean(Eager eager, Bean<?> bean) {
        if (!Utils.isEmpty(eager.requestURI())) {
            this.getRequestScopedBeansByRequestURI(eager.requestURI()).add(bean);
        } else if (!Utils.isEmpty(eager.viewId())) {
            this.getRequestScopedBeansByViewId(eager.viewId()).add(bean);
        } else {
            logger.severe(String.format(MISSING_REQUEST_URI_OR_VIEW_ID, bean.getBeanClass().getName(), RequestScoped.class.getName()));
        }
    }

    private void addViewScopedBean(Eager eager, Bean<?> bean) {
        if (!Utils.isEmpty(eager.viewId())) {
            this.getRequestScopedBeansByViewId(eager.viewId()).add(bean);
        } else {
            logger.severe(String.format(MISSING_VIEW_ID, bean.getBeanClass().getName(), javax.faces.view.ViewScoped.class.getName()));
        }
    }

    private void addOmniViewScopedBean(Eager eager, Bean<?> bean) {
        if (!Utils.isEmpty(eager.viewId())) {
            this.getRequestScopedBeansByViewId(eager.viewId()).add(bean);
        } else {
            logger.severe(String.format(MISSING_VIEW_ID, bean.getBeanClass().getName(), ViewScoped.class.getName()));
        }
    }

    private List<Bean<?>> getRequestScopedBeansByViewId(String viewId) {
        List<Bean<?>> beans = this.requestScopedBeansViewId.get(viewId);
        if (beans == null) {
            beans = new ArrayList();
            this.requestScopedBeansViewId.put(viewId, beans);
        }
        return beans;
    }

    private List<Bean<?>> getRequestScopedBeansByRequestURI(String requestURI) {
        List<Bean<?>> beans = this.requestScopedBeansRequestURI.get(requestURI);
        if (beans == null) {
            beans = new ArrayList();
            this.requestScopedBeansRequestURI.put(requestURI, beans);
        }
        return beans;
    }
}

