/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.eager;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import org.omnifaces.config.BeanManager;
import org.omnifaces.util.Utils;

@ApplicationScoped
public class EagerBeansRepository {
    private static EagerBeansRepository instance;
    @Inject
    private javax.enterprise.inject.spi.BeanManager beanManager;
    private List<Bean<?>> applicationScopedBeans;
    private List<Bean<?>> sessionScopedBeans;
    private Map<String, List<Bean<?>>> requestScopedBeansViewId;
    private Map<String, List<Bean<?>>> requestScopedBeansRequestURI;

    public static EagerBeansRepository getInstance() {
        if (instance == null) {
            instance = BeanManager.INSTANCE.getReference(EagerBeansRepository.class);
        }
        return instance;
    }

    public void instantiateApplicationScoped() {
        if (Utils.isAnyEmpty(this.applicationScopedBeans, this.beanManager)) {
            return;
        }
        this.instantiateBeans(this.applicationScopedBeans);
    }

    public void instantiateSessionScoped() {
        if (Utils.isAnyEmpty(this.sessionScopedBeans, this.beanManager)) {
            return;
        }
        this.instantiateBeans(this.sessionScopedBeans);
    }

    public void instantiateByRequestURI(String relativeRequestURI) {
        this.instantiateRequestScopedBeans(this.requestScopedBeansRequestURI, relativeRequestURI);
    }

    public void instantiateByViewID(String viewId) {
        this.instantiateRequestScopedBeans(this.requestScopedBeansViewId, viewId);
    }

    private void instantiateRequestScopedBeans(Map<String, List<Bean<?>>> beans, String key) {
        if (Utils.isAnyEmpty(beans, this.beanManager) || !beans.containsKey(key)) {
            return;
        }
        this.instantiateBeans(beans.get(key));
    }

    private void instantiateBeans(List<Bean<?>> beans) {
        for (Bean<?> bean : beans) {
            this.beanManager.getReference(bean, (Type)bean.getBeanClass(), this.beanManager.createCreationalContext(bean)).toString();
        }
    }

    void setApplicationScopedBeans(List<Bean<?>> applicationScopedBeans) {
        this.applicationScopedBeans = applicationScopedBeans;
    }

    void setSessionScopedBeans(List<Bean<?>> sessionScopedBeans) {
        this.sessionScopedBeans = sessionScopedBeans;
    }

    void setRequestScopedBeansViewId(Map<String, List<Bean<?>>> requestScopedBeansViewId) {
        this.requestScopedBeansViewId = requestScopedBeansViewId;
    }

    void setRequestScopedBeansRequestURI(Map<String, List<Bean<?>>> requestScopedBeansRequestURI) {
        this.requestScopedBeansRequestURI = requestScopedBeansRequestURI;
    }
}

