/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.converter;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import org.omnifaces.util.BeansLocal;

@ApplicationScoped
public class ConverterManager {
    @Inject
    private BeanManager manager;
    private Map<String, Bean<Converter>> convertersById = new HashMap<String, Bean<Converter>>();
    private Map<Class<?>, Bean<Converter>> convertersByForClass = new HashMap();

    public Converter createConverter(Application application, String converterId) {
        Object bean = this.convertersById.get(converterId);
        if (bean == null && !this.convertersById.containsKey(converterId)) {
            Converter converter = application.createConverter(converterId);
            if (converter != null) {
                bean = BeansLocal.resolve(this.manager, converter.getClass());
            }
            this.convertersById.put(converterId, (Bean<Converter>)bean);
        }
        return bean != null ? BeansLocal.getReference(this.manager, bean) : null;
    }

    public Converter createConverter(Application application, Class<?> converterForClass) {
        Object bean = this.convertersByForClass.get(converterForClass);
        if (bean == null && !this.convertersByForClass.containsKey(converterForClass)) {
            Converter converter = application.createConverter(converterForClass);
            if (converter != null) {
                bean = BeansLocal.resolve(this.manager, converter.getClass());
            }
            this.convertersByForClass.put(converterForClass, (Bean<Converter>)bean);
        }
        return bean != null ? BeansLocal.getReference(this.manager, bean) : null;
    }
}

