/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.application;

import java.util.TimeZone;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.validator.Validator;
import org.omnifaces.cdi.converter.ConverterManager;
import org.omnifaces.cdi.validator.ValidatorManager;
import org.omnifaces.config.BeanManager;
import org.omnifaces.util.Faces;

public class OmniApplication
extends ApplicationWrapper {
    private final Application wrapped;
    private final ConverterManager converterManager;
    private final ValidatorManager validatorManager;
    private final TimeZone dateTimeConverterDefaultTimeZone;

    public OmniApplication(Application wrapped) {
        this.wrapped = wrapped;
        this.converterManager = BeanManager.INSTANCE.getReference(ConverterManager.class);
        this.validatorManager = BeanManager.INSTANCE.getReference(ValidatorManager.class);
        this.dateTimeConverterDefaultTimeZone = Boolean.valueOf(Faces.getInitParameter("javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE")) != false ? TimeZone.getDefault() : null;
    }

    public Converter createConverter(String converterId) {
        Converter converter = this.converterManager.createConverter(this.getWrapped(), converterId);
        if (converter != null) {
            this.setDefaultPropertiesIfNecessary(converter);
            return converter;
        }
        return super.createConverter(converterId);
    }

    public Converter createConverter(Class<?> forClass) {
        Converter converter = this.converterManager.createConverter(this.getWrapped(), forClass);
        if (converter != null) {
            this.setDefaultPropertiesIfNecessary(converter);
            return converter;
        }
        return super.createConverter(forClass);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        Validator validator = this.validatorManager.createValidator(this.getWrapped(), validatorId);
        if (validator != null) {
            return validator;
        }
        return super.createValidator(validatorId);
    }

    public Application getWrapped() {
        return this.wrapped;
    }

    private void setDefaultPropertiesIfNecessary(Converter converter) {
        if (converter instanceof DateTimeConverter && this.dateTimeConverterDefaultTimeZone != null) {
            ((DateTimeConverter)converter).setTimeZone(this.dateTimeConverterDefaultTimeZone);
        }
    }
}

